import { Expression, Literal } from '../codegen-steps';
export const branchingOperators = [
    [
        '?',
        ['if'],
        3,
        (expr, ctx) => {
            return ctx.eval(expr[1], ctx) ? ctx.eval(expr[2], ctx) : ctx.eval(expr[3], ctx);
        },
        (ctx) => {
            const condition = ctx.operands[0];
            const then = ctx.operands[1];
            const otherwise = ctx.operands[2];
            if (condition instanceof Literal)
                return condition.val ? then : otherwise;
            return new Expression(`(${condition})?(${then}):(${otherwise})`);
        },
    ],
    [
        'throw',
        [],
        1,
        (expr, ctx) => {
            throw ctx.eval(expr[1], ctx);
        },
        (ctx) => {
            return new Expression(`(function(){throw (${ctx.operands[0]})})()`);
        },
    ],
];
