import * as util from '../util';
import { Expression } from '../codegen-steps';
export const objectOperators = [
    [
        'keys',
        [],
        1,
        (expr, ctx) => {
            const operand = ctx.eval(expr[1], ctx);
            return util.keys(operand);
        },
        (ctx) => {
            ctx.link(util.keys, 'keys');
            const js = `keys(${ctx.operands[0]})`;
            return new Expression(js);
        },
    ],
    [
        'values',
        [],
        1,
        (expr, ctx) => {
            const operand = ctx.eval(expr[1], ctx);
            return util.values(operand);
        },
        (ctx) => {
            ctx.link(util.values, 'values');
            const js = `values(${ctx.operands[0]})`;
            return new Expression(js);
        },
    ],
    [
        'entries',
        [],
        1,
        (expr, ctx) => {
            const operand = ctx.eval(expr[1], ctx);
            return util.entries(operand);
        },
        (ctx) => {
            ctx.link(util.entries, 'entries');
            const js = `entries(${ctx.operands[0]})`;
            return new Expression(js);
        },
    ],
];
