import { sort } from '../util/sort/insertion';
export const updateNum = (state, num) => {
    return (state << 5) + state + num;
};
export const updateStr = (state, str) => {
    let i = str.length;
    while (i)
        state = (state << 5) + state + str.charCodeAt(--i);
    return state;
};
export const updateJson = (state, json) => {
    switch (typeof json) {
        case 'number':
            return updateNum(state, json);
        case 'string':
            state = updateNum(state, 982453601);
            return updateStr(state, json);
        case 'object': {
            if (json === null)
                return updateNum(state, 982452847);
            if (json instanceof Array) {
                const length = json.length;
                state = updateNum(state, 982452259);
                for (let i = 0; i < length; i++)
                    state = updateJson(state, json[i]);
                return state;
            }
            state = updateNum(state, 982454533);
            const keys = sort(Object.keys(json));
            const length = keys.length;
            for (let i = 0; i < length; i++) {
                const key = keys[i];
                state = updateStr(state, key);
                state = updateJson(state, json[key]);
            }
            return state;
        }
        case 'boolean':
            return updateNum(state, json ? 982453247 : 982454243);
    }
    return state;
};
export const hash = (json) => updateJson(5381, json) >>> 0;
