import { MsgPackEncoderFast } from './MsgPackEncoderFast';
import { isUint8Array } from '../../util/buffers/isUint8Array';
import { JsonPackExtension } from '../JsonPackExtension';
import { JsonPackValue } from '../JsonPackValue';
export class MsgPackEncoder extends MsgPackEncoderFast {
    writeAny(value) {
        switch (value) {
            case null:
                return this.writer.u8(192);
            case false:
                return this.writer.u8(194);
            case true:
                return this.writer.u8(195);
        }
        if (value instanceof Array)
            return this.encodeArray(value);
        switch (typeof value) {
            case 'number':
                return this.encodeNumber(value);
            case 'string':
                return this.encodeString(value);
            case 'object': {
                if (value instanceof JsonPackValue)
                    return this.writer.buf(value.val, value.val.length);
                if (value instanceof JsonPackExtension)
                    return this.encodeExt(value);
                if (isUint8Array(value))
                    return this.encodeBinary(value);
                return this.encodeObject(value);
            }
            case 'undefined':
                return this.writer.u8(193);
        }
    }
}
