import { $$find } from '../../../json-pointer/codegen/find';
import { compileClosure } from '../../../util/codegen';
import { predicateOpWrapper } from '../util';
export const $$starts = (op) => {
    const compareValue = op.ignore_case ? op.value.toLowerCase() : op.value;
    const js = `
(function(wrapper){
  var find = ${$$find(op.path)};
  return wrapper(function(doc){
    var val = find(doc);
    if (typeof val !== 'string') return false;
    var outer = ${op.ignore_case ? `val.toLowerCase()` : `val`};
    return outer.indexOf(${JSON.stringify(compareValue)}) === 0;
  });
})`;
    return {
        deps: [predicateOpWrapper],
        js: js,
    };
};
export const $starts = (op) => compileClosure($$starts(op));
