import type { CompactAddOp } from '../codec/compact/types';
import { AbstractOp } from './AbstractOp';
import { OperationAdd } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpAdd extends AbstractOp<'add'> {
    readonly value: unknown;
    constructor(path: Path, value: unknown);
    op(): "add";
    code(): OPCODE;
    apply(doc: unknown): {
        doc: unknown;
        old: any;
    };
    toJson(parent?: AbstractOp): OperationAdd;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactAddOp;
    encode(encoder: IMessagePackEncoder): void;
}
