import type { CompactDefinedOp } from '../codec/compact/types';
import { AbstractPredicateOp } from './AbstractPredicateOp';
import { OperationDefined } from '../types';
import { Path } from '../../json-pointer';
import { OPCODE } from '../constants';
import { AbstractOp } from './AbstractOp';
import type { IMessagePackEncoder } from '../../json-pack/msgpack';
export declare class OpDefined extends AbstractPredicateOp<'defined'> {
    constructor(path: Path);
    op(): "defined";
    code(): OPCODE;
    test(doc: unknown): boolean;
    toJson(parent?: AbstractOp): OperationDefined;
    toCompact(parent: undefined | AbstractOp, verbose: boolean): CompactDefinedOp;
    encode(encoder: IMessagePackEncoder, parent?: AbstractOp): void;
}
