import { AbstractPredicateOp } from './AbstractPredicateOp';
import { find, formatJsonPointer } from '../../json-pointer';
export class OpDefined extends AbstractPredicateOp {
    constructor(path) {
        super(path);
    }
    op() {
        return 'defined';
    }
    code() {
        return 31;
    }
    test(doc) {
        const { val } = find(doc, this.path);
        const test = val !== undefined;
        return test;
    }
    toJson(parent) {
        const op = {
            op: 'defined',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'defined' : 31;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(2);
        encoder.writer.u8(31);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
    }
}
