import { AbstractOp } from './AbstractOp';
import { find, isArrayReference, isObjectReference, formatJsonPointer } from '../../json-pointer';
const { isArray } = Array;
export class OpExtend extends AbstractOp {
    props;
    deleteNull;
    constructor(path, props, deleteNull) {
        super(path);
        this.props = props;
        this.deleteNull = deleteNull;
    }
    op() {
        return 'extend';
    }
    code() {
        return 12;
    }
    apply(doc) {
        const ref = find(doc, this.path);
        if (isArrayReference(ref)) {
            if (ref.val !== undefined) {
                ref.obj[ref.key] = this.extend(ref.val);
            }
        }
        else if (isObjectReference(ref)) {
            ref.obj[ref.key] = this.extend(ref.val);
        }
        else {
            doc = this.extend(doc);
        }
        return { doc };
    }
    extend(value) {
        if (isArray(value))
            return value;
        if (typeof value !== 'object')
            return value;
        if (!value)
            return value;
        for (const [key, v] of Object.entries(this.props)) {
            if (key === '__proto__')
                throw new Error('NO_PROTO');
            if (v === null && this.deleteNull) {
                delete value[key];
                continue;
            }
            value[key] = v;
        }
        return value;
    }
    toJson(parent) {
        const op = {
            op: 'extend',
            path: formatJsonPointer(this.path),
            props: this.props,
        };
        if (this.deleteNull)
            op.deleteNull = this.deleteNull;
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'extend' : 12;
        return this.deleteNull ? [opcode, this.path, this.props, 1] : [opcode, this.path, this.props];
    }
    encode(encoder, parent) {
        const { deleteNull } = this;
        encoder.encodeArrayHeader(deleteNull ? 4 : 3);
        encoder.writer.u8(12);
        encoder.encodeArray(this.path);
        encoder.encodeObject(this.props);
        if (deleteNull)
            encoder.writer.u8(1);
    }
}
