import { AbstractOp } from './AbstractOp';
import { find, formatJsonPointer } from '../../json-pointer';
export class OpFlip extends AbstractOp {
    constructor(path) {
        super(path);
    }
    op() {
        return 'flip';
    }
    code() {
        return 8;
    }
    apply(doc) {
        const ref = find(doc, this.path);
        if (ref.obj)
            ref.obj[ref.key] = !ref.val;
        else
            doc = !ref.val;
        return { doc, old: ref.val };
    }
    toJson(parent) {
        const op = {
            op: 'flip',
            path: formatJsonPointer(this.path),
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'flip' : 8;
        return [opcode, this.path];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(2);
        encoder.writer.u8(8);
        encoder.encodeArray(this.path);
    }
}
