import { AbstractPredicateOp } from './AbstractPredicateOp';
import { find, formatJsonPointer } from '../../json-pointer';
export class OpLess extends AbstractPredicateOp {
    value;
    constructor(path, value) {
        super(path);
        this.value = value;
    }
    op() {
        return 'less';
    }
    code() {
        return 34;
    }
    test(doc) {
        const { val } = find(doc, this.path);
        if (typeof val !== 'number')
            return false;
        const test = val < this.value;
        return test;
    }
    toJson(parent) {
        const op = {
            op: 'less',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'less' : 34;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(34);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeNumber(this.value);
    }
}
