import { AbstractOp } from './AbstractOp';
import { find, isObjectReference, isArrayReference, formatJsonPointer } from '../../json-pointer';
export class OpReplace extends AbstractOp {
    value;
    oldValue;
    constructor(path, value, oldValue) {
        super(path);
        this.value = value;
        this.oldValue = oldValue;
    }
    op() {
        return 'replace';
    }
    code() {
        return 2;
    }
    apply(doc) {
        const ref = find(doc, this.path);
        if (ref.val === undefined)
            throw new Error('NOT_FOUND');
        if (isObjectReference(ref))
            ref.obj[ref.key] = this.value;
        else if (isArrayReference(ref))
            ref.obj[ref.key] = this.value;
        else
            doc = this.value;
        return { doc, old: ref.val };
    }
    toJson(parent) {
        const json = {
            op: 'replace',
            path: formatJsonPointer(this.path),
            value: this.value,
        };
        if (this.oldValue !== undefined)
            json.oldValue = this.oldValue;
        return json;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'replace' : 2;
        return this.oldValue === undefined
            ? [opcode, this.path, this.value]
            : [opcode, this.path, this.value, this.oldValue];
    }
    encode(encoder, parent) {
        const hasOldValue = this.oldValue !== undefined;
        encoder.encodeArrayHeader(hasOldValue ? 4 : 3);
        encoder.writer.u8(2);
        encoder.encodeArray(this.path);
        encoder.encodeAny(this.value);
        if (hasOldValue)
            encoder.encodeAny(this.oldValue);
    }
}
