import { AbstractPredicateOp } from './AbstractPredicateOp';
import { find, formatJsonPointer } from '../../json-pointer';
const { isArray } = Array;
export class OpType extends AbstractPredicateOp {
    value;
    constructor(path, value) {
        super(path);
        this.value = value;
    }
    op() {
        return 'type';
    }
    code() {
        return 42;
    }
    test(doc) {
        const { val } = find(doc, this.path);
        if (val === null)
            return this.value === 'null';
        if (isArray(val))
            return this.value === 'array';
        if (typeof val === this.value)
            return true;
        if (typeof val === 'number' && val === Math.round(val) && this.value === 'integer')
            return true;
        return false;
    }
    toJson(parent) {
        const op = {
            op: 'type',
            path: formatJsonPointer(parent ? this.path.slice(parent.path.length) : this.path),
            value: this.value,
        };
        return op;
    }
    toCompact(parent, verbose) {
        const opcode = verbose ? 'type' : 42;
        return [opcode, parent ? this.path.slice(parent.path.length) : this.path, this.value];
    }
    encode(encoder, parent) {
        encoder.encodeArrayHeader(3);
        encoder.writer.u8(42);
        encoder.encodeArray(parent ? this.path.slice(parent.path.length) : this.path);
        encoder.encodeString(this.value);
    }
}
