import { hasOwnProperty } from '../util/hasOwnProperty';
const { isArray } = Array;
export const find = (val, path) => {
    const pathLength = path.length;
    if (!pathLength)
        return { val };
    let obj;
    let key;
    for (let i = 0; i < pathLength; i++) {
        obj = val;
        key = path[i];
        if (isArray(obj)) {
            const length = obj.length;
            if (key === '-')
                key = length;
            else {
                if (typeof key === 'string') {
                    const key2 = ~~key;
                    if ('' + key2 !== key)
                        throw new Error('INVALID_INDEX');
                    key = key2;
                    if (key < 0)
                        throw new Error('INVALID_INDEX');
                }
            }
            val = obj[key];
        }
        else if (typeof obj === 'object' && !!obj) {
            val = hasOwnProperty(obj, key) ? obj[key] : undefined;
        }
        else
            throw new Error('NOT_FOUND');
    }
    const ref = { val, obj, key };
    return ref;
};
export const isArrayReference = (ref) => isArray(ref.obj) && typeof ref.key === 'number';
export const isArrayEnd = (ref) => ref.obj.length === ref.key;
export const isObjectReference = (ref) => typeof ref.obj === 'object' && typeof ref.key === 'string';
