const r1 = /~1/g;
const r2 = /~0/g;
const r3 = /~/g;
const r4 = /\//g;
export function unescapeComponent(component) {
    if (component.indexOf('~') === -1)
        return component;
    return component.replace(r1, '/').replace(r2, '~');
}
export function escapeComponent(component) {
    if (component.indexOf('/') === -1 && component.indexOf('~') === -1)
        return component;
    return component.replace(r3, '~0').replace(r4, '~1');
}
export function parseJsonPointer(pointer) {
    if (!pointer)
        return [];
    return pointer.slice(1).split('/').map(unescapeComponent);
}
export function formatJsonPointer(path) {
    if (isRoot(path))
        return '';
    return '/' + path.map((component) => escapeComponent(String(component))).join('/');
}
export const toPath = (pointer) => (typeof pointer === 'string' ? parseJsonPointer(pointer) : pointer);
export function isChild(parent, child) {
    if (parent.length >= child.length)
        return false;
    for (let i = 0; i < parent.length; i++)
        if (parent[i] !== child[i])
            return false;
    return true;
}
export function isPathEqual(p1, p2) {
    if (p1.length !== p2.length)
        return false;
    for (let i = 0; i < p1.length; i++)
        if (p1[i] !== p2[i])
            return false;
    return true;
}
export const isRoot = (path) => !path.length;
export function parent(path) {
    if (path.length < 1)
        throw new Error('NO_PARENT');
    return path.slice(0, path.length - 1);
}
export function isValidIndex(index) {
    if (typeof index === 'number')
        return true;
    const n = parseInt(index, 10);
    return String(n) === index && n >= 0;
}
export const isInteger = (str) => {
    const len = str.length;
    let i = 0;
    let charCode;
    while (i < len) {
        charCode = str.charCodeAt(i);
        if (charCode >= 48 && charCode <= 57) {
            i++;
            continue;
        }
        return false;
    }
    return true;
};
