import { escape } from '../util/strings/escape';
import { sort } from '../util/sort/insertion';
const getKeys = Object.keys;
export const stringify = (val) => {
    let i, max, str, keys, key, propVal;
    switch (typeof val) {
        case 'string':
            return ('"' + escape(val) + '"');
        case 'object':
            if (val instanceof Array) {
                str = '[';
                max = val.length - 1;
                for (i = 0; i < max; i++)
                    str += stringify(val[i]) + ',';
                if (max >= 0)
                    str += stringify(val[i]);
                return (str + ']');
            }
            if (val === null)
                return 'null';
            keys = sort(getKeys(val));
            max = keys.length;
            str = '{';
            i = 0;
            while (i < max) {
                key = keys[i];
                propVal = stringify(val[key]);
                if (i && str !== '')
                    str += ',';
                str += '"' + escape(key) + '":' + propVal;
                i++;
            }
            return (str + '}');
        default:
            return String(val);
    }
};
