import { applyPatch } from '../../json-patch';
import { toPath } from '../../json-pointer';
export class CliParamNum {
    param = 'num';
    short = 'n';
    title = 'Set number value';
    example = '--n/foo=123';
    createInstance = (cli, pointer, rawValue) => new (class {
        onRequest = async () => {
            const value = Number(JSON.parse(String(rawValue)));
            const path = toPath(pointer);
            cli.request = applyPatch(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
        };
    })();
}
