import { applyPatch } from '../../json-patch';
import { find, toPath, validateJsonPointer } from '../../json-pointer';
export class CliParamStdin {
    param = 'stdin';
    short = 'in';
    title = 'Read data from STDIN';
    example = '--in or --in/to=/from';
    createInstance = (cli, pointer, rawValue) => {
        if (rawValue === true)
            rawValue = '';
        return new (class {
            onStdin = async () => {
                const fromPointer = String(rawValue);
                validateJsonPointer(fromPointer);
                validateJsonPointer(pointer);
                const from = toPath(fromPointer);
                const path = toPath(pointer);
                const value = find(cli.stdinInput, from).val;
                cli.request = applyPatch(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
            };
        })();
    };
}
