import { find, toPath, validateJsonPointer } from '../../json-pointer';
export class CliParamStdout {
    param = 'stdout';
    short = 'out';
    title = 'Write data to STDOUT';
    example = '--out=/foo';
    createInstance = (cli, _, rawValue) => {
        return new (class {
            onResponse = async () => {
                const pointer = String(rawValue);
                validateJsonPointer(pointer);
                const path = toPath(pointer);
                cli.response = find(cli.response, path).val;
            };
        })();
    };
}
