import { applyPatch } from '../../json-patch';
import { toPath } from '../../json-pointer';
export class CliParamStr {
    param = 'str';
    short = 's';
    title = 'Set string value';
    example = '--s/foo=abc';
    createInstance = (cli, pointer, rawValue) => new (class {
        onRequest = async () => {
            const value = String(rawValue);
            const path = toPath(pointer);
            cli.request = applyPatch(cli.request, [{ op: 'add', path, value }], { mutate: true }).doc;
        };
    })();
}
