import { applyPatch } from '../../json-patch';
import { toPath } from '../../json-pointer';
export class CliParamUnd {
    param = 'und';
    title = 'Set undefined value';
    createInstance = (cli, pointer, rawValue) => new (class {
        onRequest = async () => {
            const path = toPath(pointer);
            cli.request = applyPatch(cli.request, [{ op: 'add', path, value: undefined }], { mutate: true }).doc;
        };
    })();
}
