import { Codegen } from '../../../util/codegen';
import type { TypeSystem } from '../../system';
import type { Type } from '../../type';
import type { json_string } from '../../../json-brand';
export type JsonEncoderFn = <T>(value: T) => json_string<T>;
export interface JsonTextEncoderCodegenContextOptions {
    type: Type;
    system?: TypeSystem;
    name?: string;
}
export declare class JsonTextEncoderCodegenContext {
    readonly options: JsonTextEncoderCodegenContextOptions;
    readonly codegen: Codegen<JsonEncoderFn>;
    constructor(options: JsonTextEncoderCodegenContextOptions);
    js(js: string): void;
    writeText(str: string): void;
    protected base64Linked: boolean;
    linkBase64(): void;
    compile(): JsonEncoderFn;
}
