import { Codegen } from '../../../util/codegen';
import { ValidationError } from '../../constants';
import type { TypeSystem } from '../../system';
import type { Type } from '../../type';
import type { ValidationPath } from './types';
export interface ValidatorCodegenContextOptions {
    type: Type;
    system?: TypeSystem;
    errors: 'boolean' | 'string' | 'object';
    skipObjectExtraFieldsCheck?: boolean;
    unsafeMode?: boolean;
}
export declare class ValidatorCodegenContext {
    readonly options: ValidatorCodegenContextOptions;
    readonly codegen: Codegen;
    constructor(options: ValidatorCodegenContextOptions);
    js(js: string): void;
    err(code: ValidationError, path: ValidationPath, opts?: {
        refId?: string;
        refError?: string;
        validator?: string;
    }): string;
    emitCustomValidators(node: Type, path: ValidationPath, r: string): void;
    private validatorCache;
    protected linkValidator(name: string): string;
    compile(): (...deps: unknown[]) => unknown;
}
