export var ValidationError;
(function (ValidationError) {
    ValidationError[ValidationError["STR"] = 0] = "STR";
    ValidationError[ValidationError["NUM"] = 1] = "NUM";
    ValidationError[ValidationError["BOOL"] = 2] = "BOOL";
    ValidationError[ValidationError["ARR"] = 3] = "ARR";
    ValidationError[ValidationError["TUP"] = 4] = "TUP";
    ValidationError[ValidationError["OBJ"] = 5] = "OBJ";
    ValidationError[ValidationError["KEY"] = 6] = "KEY";
    ValidationError[ValidationError["KEYS"] = 7] = "KEYS";
    ValidationError[ValidationError["BIN"] = 8] = "BIN";
    ValidationError[ValidationError["OR"] = 9] = "OR";
    ValidationError[ValidationError["REF"] = 10] = "REF";
    ValidationError[ValidationError["ENUM"] = 11] = "ENUM";
    ValidationError[ValidationError["CONST"] = 12] = "CONST";
    ValidationError[ValidationError["VALIDATION"] = 13] = "VALIDATION";
    ValidationError[ValidationError["INT"] = 14] = "INT";
    ValidationError[ValidationError["UINT"] = 15] = "UINT";
    ValidationError[ValidationError["STR_LEN"] = 16] = "STR_LEN";
    ValidationError[ValidationError["ARR_LEN"] = 17] = "ARR_LEN";
    ValidationError[ValidationError["GT"] = 18] = "GT";
    ValidationError[ValidationError["GTE"] = 19] = "GTE";
    ValidationError[ValidationError["LT"] = 20] = "LT";
    ValidationError[ValidationError["LTE"] = 21] = "LTE";
})(ValidationError || (ValidationError = {}));
export const ValidationErrorMessage = {
    [ValidationError.STR]: 'Not a string.',
    [ValidationError.NUM]: 'Not a number.',
    [ValidationError.BOOL]: 'Not a boolean.',
    [ValidationError.ARR]: 'Not an array.',
    [ValidationError.TUP]: 'Not a tuple.',
    [ValidationError.OBJ]: 'Not an object.',
    [ValidationError.KEY]: 'Missing key.',
    [ValidationError.KEYS]: 'Too many or missing object keys.',
    [ValidationError.BIN]: 'Not a binary.',
    [ValidationError.OR]: 'None of types matched.',
    [ValidationError.REF]: 'Validation error in referenced type.',
    [ValidationError.ENUM]: 'Not an enum value.',
    [ValidationError.CONST]: 'Invalid constant.',
    [ValidationError.VALIDATION]: 'Custom validator failed.',
    [ValidationError.INT]: 'Not an integer.',
    [ValidationError.UINT]: 'Not an unsigned integer.',
    [ValidationError.STR_LEN]: 'Invalid string length.',
    [ValidationError.ARR_LEN]: 'Invalid array length.',
    [ValidationError.GT]: 'Value is too small.',
    [ValidationError.GTE]: 'Value is too small.',
    [ValidationError.LT]: 'Value is too large.',
    [ValidationError.LTE]: 'Value is too large.',
};
