import { printTree } from '../../util/print/printTree';
import { ObjectType } from '../type/classes';
import { toText } from '../typescript/toText';
import { TypeExportContext } from './TypeExportContext';
export class TypeAlias {
    system;
    id;
    type;
    constructor(system, id, type) {
        this.system = system;
        this.id = id;
        this.type = type;
    }
    getType() {
        return this.type;
    }
    resolve() {
        return this.system.resolve(this.id);
    }
    toString(tab = '') {
        return this.id + printTree(tab, [(tab) => this.type.toString(tab)]);
    }
    toTypeScriptAst() {
        const type = this.type;
        if (type instanceof ObjectType) {
            const ast = this.type.toTypeScriptAst();
            const node = {
                node: 'InterfaceDeclaration',
                name: this.id,
                members: ast.members,
            };
            return node;
        }
        else {
            const node = {
                node: 'TypeAliasDeclaration',
                name: this.id,
                type: type.toTypeScriptAst(),
            };
            return node;
        }
    }
    toTypeScript() {
        return toText(this.toTypeScriptAst());
    }
    toJsonSchema() {
        const node = {
            $id: this.id,
            $ref: '#/$defs/' + this.id,
            $defs: {},
        };
        const ctx = new TypeExportContext();
        ctx.visitRef(this.id);
        node.$defs[this.id] = this.type.toJsonSchema(ctx);
        let ref;
        while ((ref = ctx.nextMentionedRef())) {
            ctx.visitRef(ref);
            node.$defs[ref] = this.system.resolve(ref).type.toJsonSchema(ctx);
        }
        return node;
    }
}
