export class TypeExportContext {
    refs = new Map();
    mentionRef(ref) {
        if (!this.refs.has(ref))
            this.refs.set(ref, 'mentioned');
    }
    nextMentionedRef() {
        for (const [ref, type] of this.refs)
            if (type === 'mentioned')
                return ref;
        return undefined;
    }
    visitRef(ref) {
        this.refs.set(ref, 'visited');
    }
}
