import { TypeSystem } from './TypeSystem';
export class TypeRouter {
    static create = (routes) => {
        const system = new TypeSystem();
        const router = new TypeRouter({
            system,
            routes: {},
        });
        return routes ? router.extend(routes) : router;
    };
    system;
    t;
    routes;
    constructor(options) {
        this.system = options.system;
        this.t = this.system.t;
        this.routes = options.routes;
        this.system.importTypes(this.routes);
    }
    merge(router) {
        return new TypeRouter({
            system: this.system,
            routes: {
                ...this.routes,
                ...router.routes,
            },
        });
    }
    extend(routes) {
        const router = new TypeRouter({ system: this.system, routes: routes(this) });
        return this.merge(router);
    }
}
