import { Uint8ArrayCut } from '../../../../util/buffers/Uint8ArrayCut';
import { NotificationMessage, RequestCompleteMessage, RequestDataMessage, RequestErrorMessage, RequestUnsubscribeMessage, ResponseCompleteMessage, ResponseDataMessage, ResponseErrorMessage, ResponseUnsubscribeMessage, } from '../../messages';
import { Value } from '../../messages/Value';
export const decode = (reader) => {
    const word = reader.u32();
    const type = word >>> 29;
    switch (type) {
        case 0: {
            const z = word & 0xff;
            const x = word >>> 8;
            const name = reader.ascii(z);
            const cut = new Uint8ArrayCut(reader.uint8, reader.x, x);
            const value = new Value(cut, undefined);
            reader.skip(x);
            return new NotificationMessage(name, value);
        }
        case 1:
        case 2:
        case 3: {
            const z = reader.u8();
            const name = reader.ascii(z);
            const cutStart = reader.x;
            let x = 0, y = 0;
            if (word & 0b1_0000_00000000_00000000_00000000) {
                if (word & 0b10000000_00000000) {
                    x = ((0b1111_11111111 & (word >>> 16)) << 15) | (word & 0b1111111_11111111);
                    reader.skip(x);
                    y = reader.u16();
                }
                else {
                    x = ((0b1111_11111111 & (word >>> 16)) << 7) | ((word >>> 8) & 0x7f);
                    reader.skip(x);
                    y = ((word & 0xff) << 8) | reader.u8();
                }
            }
            else {
                x = (word >>> 16) & 0b1111_11111111;
                y = word & 0xffff;
                reader.skip(x);
            }
            const cut = new Uint8ArrayCut(reader.uint8, cutStart, x);
            const value = new Value(cut, undefined);
            switch (type) {
                case 1:
                    return new RequestDataMessage(y, name, value);
                case 2:
                    return new RequestCompleteMessage(y, name, value);
                case 3:
                    return new RequestErrorMessage(y, name, value);
            }
            break;
        }
        case 4:
        case 5:
        case 6: {
            const cutStart = reader.x;
            let x = 0, y = 0;
            if (word & 0b1_0000_00000000_00000000_00000000) {
                if (word & 0b10000000_00000000) {
                    x = ((0b1111_11111111 & (word >>> 16)) << 15) | (word & 0b1111111_11111111);
                    reader.skip(x);
                    y = reader.u16();
                }
                else {
                    x = ((0b1111_11111111 & (word >>> 16)) << 7) | ((word >>> 8) & 0x7f);
                    reader.skip(x);
                    y = ((word & 0xff) << 8) | reader.u8();
                }
            }
            else {
                x = (word >>> 16) & 0b1111_11111111;
                y = word & 0xffff;
                reader.skip(x);
            }
            const cut = new Uint8ArrayCut(reader.uint8, cutStart, x);
            const value = new Value(cut, undefined);
            switch (type) {
                case 4:
                    return new ResponseDataMessage(y, value);
                case 5:
                    return new ResponseCompleteMessage(y, value);
                case 6:
                    return new ResponseErrorMessage(y, value);
            }
            break;
        }
        case 7: {
            const isResponse = word & 0b1_00000000_00000000;
            const id = word & 0xffff;
            return isResponse ? new ResponseUnsubscribeMessage(id) : new RequestUnsubscribeMessage(id);
        }
    }
    throw new Error('UNKNOWN_MSG');
};
