import type { Value } from './Value';
import type { JsonValueCodec } from '../../../json-pack/codecs/types';
import type * as cmsg from '../codec/compact/types';
import type { Message } from './types';
export declare class NotificationMessage<V extends Value<any> = Value> implements Message<cmsg.CompactMessage> {
    readonly method: string;
    readonly value: V;
    constructor(method: string, value: V);
    validate(): void;
    toCompact(): cmsg.CompactNotificationMessage<V>;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class RequestDataMessage<V extends Value<any> = Value> implements Message<cmsg.CompactMessage> {
    readonly id: number;
    readonly method: string;
    readonly value: undefined | V;
    constructor(id: number, method: string, value: undefined | V);
    validate(): void;
    toCompact(): cmsg.CompactRequestDataMessage<V>;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class RequestCompleteMessage<V extends Value<any> = Value> implements Message<cmsg.CompactMessage> {
    readonly id: number;
    readonly method: string;
    readonly value: undefined | V;
    constructor(id: number, method: string, value: undefined | V);
    validate(): void;
    toCompact(): cmsg.CompactRequestCompleteMessage<V>;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class RequestErrorMessage<V extends Value<any> = Value> implements Message<cmsg.CompactMessage> {
    readonly id: number;
    method: string;
    readonly value: V;
    constructor(id: number, method: string, value: V);
    validate(): void;
    toCompact(): cmsg.CompactRequestErrorMessage<V>;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class RequestUnsubscribeMessage implements Message<cmsg.CompactMessage> {
    readonly id: number;
    constructor(id: number);
    validate(): void;
    toCompact(): cmsg.CompactRequestUnsubscribeMessage;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class ResponseCompleteMessage<V extends Value<any> = Value> implements Message<cmsg.CompactMessage> {
    readonly id: number;
    readonly value: undefined | V;
    constructor(id: number, value: undefined | V);
    validate(): void;
    toCompact(): cmsg.CompactResponseCompleteMessage<V>;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class ResponseDataMessage<V extends Value<any> = Value> implements Message<cmsg.CompactMessage> {
    readonly id: number;
    readonly value: V;
    constructor(id: number, value: V);
    validate(): void;
    toCompact(): cmsg.CompactResponseDataMessage<V>;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class ResponseErrorMessage<V extends Value<any> = Value> implements Message<cmsg.CompactMessage> {
    readonly id: number;
    readonly value: V;
    constructor(id: number, value: V);
    validate(): void;
    toCompact(): cmsg.CompactResponseErrorMessage<V>;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
export declare class ResponseUnsubscribeMessage implements Message<cmsg.CompactMessage> {
    readonly id: number;
    constructor(id: number);
    validate(): void;
    toCompact(): cmsg.CompactResponseUnsubscribeMessage;
    encodeCompact(codec: JsonValueCodec): void;
    encodeBinary(codec: JsonValueCodec): void;
}
