import { timer, from, Observable } from 'rxjs';
import { map, switchMap, take } from 'rxjs/operators';
import { t } from '../../../../json-type';
import { RpcError } from '../caller';
import { ApiRpcCaller } from '../caller/ApiRpcCaller';
const ping = {
    isStreaming: false,
    call: async () => {
        return 'pong';
    },
    res: t.Const('pong'),
};
const delay = {
    isStreaming: false,
    call: async ({ timeout = 10 } = {}) => {
        await new Promise((r) => setTimeout(r, timeout));
        return {
            done: true,
            timeout,
        };
    },
};
let value = 0;
const notificationSetValue = {
    isStreaming: false,
    call: async (params) => {
        value = params.value;
    },
    res: t.Const(undefined),
};
const getValue = {
    isStreaming: false,
    call: async () => {
        return { value };
    },
};
const delayStreaming = {
    isStreaming: true,
    call$: (req$) => {
        return req$.pipe(take(1), switchMap(({ timeout = 10 } = {}) => {
            return from(new Promise((r) => {
                setTimeout(() => {
                    r(timeout);
                }, timeout);
            }));
        }), map((timeout) => ({
            done: true,
            timeout,
        })));
    },
};
const double = {
    isStreaming: false,
    validate: (data) => {
        if (typeof data !== 'object')
            throw RpcError.validation('Payload must be object.');
        if (data === null)
            throw RpcError.validation('Payload cannot be null.');
        if (typeof data.num !== 'number')
            throw RpcError.validation('Payload .num field missing.');
    },
    call: async ({ num }) => ({ num: num * 2 }),
};
const error = {
    isStreaming: false,
    call: async () => {
        throw new RpcError('this promise can throw', '', 0, '', undefined);
    },
};
const getUser = {
    isStreaming: false,
    call: async (request) => {
        return {
            id: request.id,
            name: 'Mario Dragi',
            tags: ['news', 'cola', 'bcaa'],
        };
    },
};
const streamError = {
    isStreaming: true,
    call$: () => from((async () => {
        throw RpcError.internal('Stream always errors');
    })()),
};
const utilTimer = {
    isStreaming: true,
    call$: () => timer(10, 10),
};
const buildinfo = {
    isStreaming: true,
    call$: () => from([
        {
            commit: 'AAAAAAAAAAAAAAAAAAA',
            sha1: 'BBBBBBBBBBBBBBBBBBB',
        },
    ]),
};
const count = {
    isStreaming: true,
    call$: (request$) => {
        return request$.pipe(switchMap(({ count }) => new Observable((observer) => {
            let cnt = 0;
            const timer = setInterval(() => {
                observer.next(cnt++);
                if (cnt >= count) {
                    observer.complete();
                    clearInterval(timer);
                }
            }, 10);
            return () => {
                clearInterval(timer);
            };
        })));
    },
};
const doubleStringWithValidation = {
    isStreaming: false,
    validate: (request) => {
        if (!request || typeof request !== 'object')
            throw RpcError.validation('Request must be object.');
        if (typeof request.foo !== 'string')
            throw RpcError.validation('"foo" property missing.');
    },
    call: async ({ foo }) => {
        return { bar: foo + foo };
    },
};
const doubleStringWithValidation2 = {
    isStreaming: true,
    validate: (request) => {
        if (!request || typeof request !== 'object')
            throw RpcError.validation('Request must be object.');
        if (typeof request.foo !== 'string')
            throw RpcError.validation('"foo" property missing.');
    },
    call$: (req$) => {
        return req$.pipe(map(({ foo }) => ({ bar: foo + foo })));
    },
};
const passthroughStream = {
    isStreaming: true,
    call$: (req$) => req$,
};
export const sampleApi = {
    ping,
    delay,
    notificationSetValue,
    getValue,
    delayStreaming,
    double,
    count,
    error,
    streamError,
    'auth.users.get': getUser,
    'util.info': buildinfo,
    'util.timer': utilTimer,
    doubleStringWithValidation,
    doubleStringWithValidation2,
    passthroughStream,
};
export const createCaller = () => new ApiRpcCaller({ api: sampleApi });
