import { StaticRpcMethod } from '../methods/StaticRpcMethod';
import { StreamingRpcMethod } from '../methods/StreamingRpcMethod';
import { RpcCaller, RpcApiCallerOptions } from './RpcCaller';
import type { IStaticRpcMethod, IStreamingRpcMethod } from '../types';
import type { RpcApiMap } from './types';
export interface ApiRpcCallerOptions<Api extends RpcApiMap<Ctx>, Ctx = unknown> extends Omit<RpcApiCallerOptions<Ctx>, 'getMethod'> {
    api: Api;
}
export declare class ApiRpcCaller<Api extends RpcApiMap<Ctx>, Ctx = unknown, Methods = {
    [K in keyof Api]: Api[K] extends IStaticRpcMethod<infer Ctx, infer Req, infer Res> ? StaticRpcMethod<Ctx, Req, Res> : Api[K] extends IStreamingRpcMethod<infer Ctx, infer Req, infer Res> ? StreamingRpcMethod<Ctx, Req, Res> : never;
}> extends RpcCaller<Ctx> {
    protected readonly methods: Map<string, StaticRpcMethod<unknown, unknown, unknown> | StreamingRpcMethod<unknown, unknown, unknown>>;
    constructor({ api, ...rest }: ApiRpcCallerOptions<Api, Ctx>);
    protected get<K extends keyof Methods>(name: K): Methods[K] | undefined;
}
