import { StaticRpcMethod } from '../methods/StaticRpcMethod';
import { StreamingRpcMethod } from '../methods/StreamingRpcMethod';
import { RpcCaller } from './RpcCaller';
export class ApiRpcCaller extends RpcCaller {
    methods = new Map();
    constructor({ api, ...rest }) {
        super({
            ...rest,
            getMethod: (name) => this.get(name),
        });
        for (const key in api) {
            const method = api[key];
            this.methods.set(key, (method.isStreaming ? new StreamingRpcMethod(method) : new StaticRpcMethod(method)));
        }
    }
    get(name) {
        return this.methods.get(name);
    }
}
