import { Value } from '../../../messages/Value';
import { RpcErrorType } from './RpcErrorType';
export var RpcErrorCodes;
(function (RpcErrorCodes) {
    RpcErrorCodes[RpcErrorCodes["INTERNAL_ERROR"] = 0] = "INTERNAL_ERROR";
    RpcErrorCodes[RpcErrorCodes["BAD_REQUEST"] = 1] = "BAD_REQUEST";
    RpcErrorCodes[RpcErrorCodes["TIMEOUT"] = 2] = "TIMEOUT";
    RpcErrorCodes[RpcErrorCodes["NOT_FOUND"] = 3] = "NOT_FOUND";
    RpcErrorCodes[RpcErrorCodes["CONFLICT"] = 4] = "CONFLICT";
    RpcErrorCodes[RpcErrorCodes["ID_TAKEN"] = 5] = "ID_TAKEN";
    RpcErrorCodes[RpcErrorCodes["INVALID_METHOD"] = 6] = "INVALID_METHOD";
    RpcErrorCodes[RpcErrorCodes["INVALID_METHOD_NAME"] = 7] = "INVALID_METHOD_NAME";
    RpcErrorCodes[RpcErrorCodes["NO_METHOD_SPECIFIED"] = 8] = "NO_METHOD_SPECIFIED";
    RpcErrorCodes[RpcErrorCodes["METHOD_NOT_FOUND"] = 9] = "METHOD_NOT_FOUND";
    RpcErrorCodes[RpcErrorCodes["STOP"] = 10] = "STOP";
    RpcErrorCodes[RpcErrorCodes["DISCONNECT"] = 11] = "DISCONNECT";
    RpcErrorCodes[RpcErrorCodes["BUFFER_OVERFLOW"] = 12] = "BUFFER_OVERFLOW";
})(RpcErrorCodes || (RpcErrorCodes = {}));
export class RpcError extends Error {
    message;
    code;
    errno;
    errorId;
    meta;
    static from(error) {
        if (error instanceof RpcError)
            return error;
        return RpcError.internal();
    }
    static fromCode(errno, message = '', meta = undefined) {
        const code = RpcErrorCodes[errno];
        return new RpcError(message || code, code, errno, undefined, meta || undefined);
    }
    static internal(message = 'Internal Server Error') {
        return RpcError.fromCode(RpcErrorCodes.INTERNAL_ERROR, message);
    }
    static invalidRequest() {
        return RpcError.fromCode(RpcErrorCodes.BAD_REQUEST, 'Bad Request');
    }
    static validation(message, meta) {
        return RpcError.fromCode(RpcErrorCodes.BAD_REQUEST, message, meta);
    }
    static value(error) {
        return new Value(error, RpcErrorType);
    }
    static valueFrom(error, def = RpcError.internalErrorValue()) {
        if (error instanceof Value && error.data instanceof RpcError && error.type === RpcErrorType)
            return error;
        if (error instanceof RpcError)
            return RpcError.value(error);
        return def;
    }
    static valueFromCode(errno, message) {
        return RpcError.value(RpcError.fromCode(errno, message));
    }
    static internalErrorValue() {
        return RpcError.value(RpcError.internal());
    }
    static isRpcError(error) {
        return error instanceof RpcError;
    }
    constructor(message, code, errno, errorId, meta) {
        super(message);
        this.message = message;
        this.code = code;
        this.errno = errno;
        this.errorId = errorId;
        this.meta = meta;
        if (message === code)
            this.code = undefined;
        Object.setPrototypeOf(this, RpcError.prototype);
    }
    toJson() {
        const err = { message: this.message };
        if (this.code)
            err.code = this.code;
        if (this.errno)
            err.errno = this.errno;
        if (this.errorId)
            err.errorId = this.errorId;
        if (this.meta)
            err.meta = this.meta;
        return err;
    }
}
