export class EncodedStaticRpcClient {
    client;
    constructor({ send, msgCodec, reqCodec, resCodec = reqCodec, client }) {
        this.client = client;
        client.onsend = async (messages) => {
            const buf = msgCodec.encode(reqCodec, messages);
            const res = await send(buf);
            const resultMessages = msgCodec.decodeBatch(resCodec, res);
            return resultMessages;
        };
    }
    call$(method, data) {
        return this.client.call$(method, data);
    }
    async call(method, request) {
        return this.call(method, request);
    }
    notify(method, data) {
        this.notify(method, data);
    }
}
