import { StaticRpcClient } from './StaticRpcClient';
import { EncodedStaticRpcClient } from './EncodedStaticRpcClient';
export class FetchRpcClient {
    client;
    constructor(options) {
        const { msgCodec, reqCodec, resCodec = reqCodec, url } = options;
        let contentType = `application/x.rpc.${msgCodec.id}.${reqCodec.id}`;
        if (reqCodec.id !== resCodec.id)
            contentType += `-${resCodec.id}`;
        const myFetch = options.fetch || fetch;
        this.client = new EncodedStaticRpcClient({
            client: new StaticRpcClient({
                bufferSize: options.bufferSize,
                bufferTime: options.bufferTime,
            }),
            msgCodec,
            reqCodec,
            resCodec,
            send: async (body) => {
                const response = await myFetch(url, {
                    method: 'POST',
                    headers: {
                        'Content-Type': contentType,
                    },
                    body,
                });
                const buffer = await response.arrayBuffer();
                return new Uint8Array(buffer);
            },
        });
    }
    call$(method, data) {
        return this.client.call$(method, data);
    }
    async call(method, request) {
        return this.call(method, request);
    }
    notify(method, data) {
        this.notify(method, data);
    }
}
