import { firstValueFrom, from } from 'rxjs';
export class StaticRpcMethod {
    isStreaming = false;
    pretty;
    validate;
    onPreCall;
    req;
    res;
    call;
    call$;
    acceptsNotifications;
    constructor(options) {
        const { call, validate, onPreCall, pretty, req, res } = options;
        this.pretty = !!pretty;
        this.validate = validate;
        this.onPreCall = onPreCall;
        this.req = req;
        this.res = res;
        const responseIsVoid = !!res && res.getTypeName() === 'const' && res.getSchema().value === undefined;
        this.acceptsNotifications = responseIsVoid;
        this.call = call;
        this.call$ = (request$, ctx) => from((async () => this.call(await firstValueFrom(request$), ctx))());
    }
}
