import { firstValueFrom, of } from 'rxjs';
export class StreamingRpcMethod {
    isStreaming = true;
    pretty;
    validate;
    onPreCall;
    req;
    res;
    call;
    call$;
    preCallBufferSize;
    constructor(options) {
        const { call$, onPreCall, pretty, validate, req, res, preCallBufferSize } = options;
        this.pretty = !!pretty;
        this.validate = validate;
        this.onPreCall = onPreCall;
        this.req = req;
        this.res = res;
        this.preCallBufferSize = preCallBufferSize;
        this.call = (request, ctx) => firstValueFrom(call$(of(request), ctx));
        this.call$ = call$;
    }
}
