import { microtask } from './microtask';
export function subscribeSyncObserver(observable, observer) {
    let completed = false;
    let buffer = [];
    const flush = () => {
        if (!buffer.length)
            return;
        observer.next(buffer, completed);
        buffer = [];
    };
    return observable.subscribe({
        next: (data) => {
            buffer.push(data);
            if (buffer.length === 1)
                microtask(flush);
        },
        error: (error) => {
            flush();
            observer.error(error);
        },
        complete: () => {
            completed = true;
            flush();
            observer.complete();
        },
    });
}
