import { randomBytes } from 'crypto';
function xoshiro128ss(a, b, c, d) {
    return () => {
        const t = b << 9;
        let r = b * 5;
        r = ((r << 7) | (r >>> 25)) * 9;
        c ^= a;
        d ^= b;
        b ^= c;
        a ^= d;
        c ^= t;
        d = (d << 11) | (d >>> 21);
        return (r >>> 0) / 4294967296;
    };
}
export class Fuzzer {
    static randomInt(min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    }
    static pick(elements) {
        return elements[Math.floor(Math.random() * elements.length)];
    }
    static repeat(times, callback) {
        const result = [];
        for (let i = 0; i < times; i++)
            result.push(callback());
        return result;
    }
    seed;
    random;
    constructor(seed) {
        this.seed = seed = seed || randomBytes(4 * 4);
        let i = 0;
        const a = (seed[i++] << 24) | (seed[i++] << 16) | (seed[i++] << 8) | seed[i++];
        const b = (seed[i++] << 24) | (seed[i++] << 16) | (seed[i++] << 8) | seed[i++];
        const c = (seed[i++] << 24) | (seed[i++] << 16) | (seed[i++] << 8) | seed[i++];
        const d = (seed[i++] << 24) | (seed[i++] << 16) | (seed[i++] << 8) | seed[i++];
        this.random = xoshiro128ss(a, b, c, d);
        Math.random = this.random;
    }
    randomInt = (min, max) => {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    };
    pick = (elements) => {
        return elements[Math.floor(Math.random() * elements.length)];
    };
    repeat = (times, callback) => {
        const result = [];
        for (let i = 0; i < times; i++)
            result.push(callback());
        return result;
    };
}
