import decodeUtf8 from './decodeUtf8/v10';
import { randomU32 } from 'hyperdyperid/lib/randomU32';
class CacheItem {
    bytes;
    value;
    constructor(bytes, value) {
        this.bytes = bytes;
        this.value = value;
    }
}
export class CachedUtf8Decoder {
    caches;
    constructor() {
        this.caches = [];
        for (let i = 0; i < 31; i++)
            this.caches.push([]);
    }
    get(bytes, offset, size) {
        const records = this.caches[size - 1];
        const len = records.length;
        FIND_CHUNK: for (let i = 0; i < len; i++) {
            const record = records[i];
            const recordBytes = record.bytes;
            for (let j = 0; j < size; j++)
                if (recordBytes[j] !== bytes[offset + j])
                    continue FIND_CHUNK;
            return record.value;
        }
        return null;
    }
    store(bytes, value) {
        const records = this.caches[bytes.length - 1];
        const record = new CacheItem(bytes, value);
        const length = records.length;
        if (length >= 16)
            records[randomU32(0, 16 - 1)] = record;
        else
            records.push(record);
    }
    decode(bytes, offset, size) {
        if (!size)
            return '';
        const cachedValue = this.get(bytes, offset, size);
        if (cachedValue !== null)
            return cachedValue;
        const value = decodeUtf8(bytes, offset, size);
        const copy = Uint8Array.prototype.slice.call(bytes, offset, offset + size);
        this.store(copy, value);
        return value;
    }
}
