export class ExactStep {
    text;
    constructor(text) {
        this.text = text;
    }
    toText() {
        return this.text;
    }
}
export class UntilStep {
    name;
    until;
    constructor(name, until) {
        this.name = name;
        this.until = until;
    }
    toText() {
        const until = this.until === '\n' ? '\\n' : this.until;
        return `{${this.name}::${until}}`;
    }
}
export class RegexStep {
    name;
    regex;
    until;
    constructor(name, regex, until) {
        this.name = name;
        this.regex = regex;
        this.until = until;
    }
    toText() {
        const regex = this.regex || this.until ? ':' + this.regex : '';
        const until = this.until ? ':' + this.until : '';
        return `{${this.name}${regex}${until}}`;
    }
}
