import { Subject } from 'rxjs';
import { RpcError, RpcErrorCodes } from '../../reactive-rpc/common/rpc/caller';
export class BufferSubject extends Subject {
    bufferSize;
    buffer = [];
    isBuffering = true;
    constructor(bufferSize) {
        super();
        this.bufferSize = bufferSize;
    }
    _subscribe(subscriber) {
        this._throwIfClosed();
        const subscription = this._innerSubscribe(subscriber);
        const { buffer } = this;
        for (let i = 0; i < buffer.length && !subscriber.closed; i += 1) {
            subscriber.next(buffer[i]);
        }
        this._checkFinalizedStatuses(subscriber);
        return subscription;
    }
    next(value) {
        if (this.isBuffering) {
            if (this.buffer.length >= this.bufferSize) {
                this.error(RpcError.fromCode(RpcErrorCodes.BUFFER_OVERFLOW));
                return;
            }
            this.buffer.push(value);
        }
        super.next(value);
    }
    flush() {
        this.isBuffering = false;
        this.buffer = [];
    }
}
