import { find, findOrNextLower, first, insert, last, next, remove } from './util';
import { splay } from './splay/util';
import { TreeNode } from './TreeNode';
const defaultComparator = (a, b) => a - b;
export class Tree {
    comparator;
    root = undefined;
    size = 0;
    constructor(comparator = defaultComparator) {
        this.comparator = comparator;
    }
    set(key, value) {
        const node = new TreeNode(key, value);
        this.root = insert(this.root, node, this.comparator);
        this.root = splay(this.root, node, 15);
        this.size++;
    }
    setFast(key, value) {
        const node = new TreeNode(key, value);
        this.root = insert(this.root, node, this.comparator);
        this.size++;
    }
    get(key) {
        const node = find(this.root, key, this.comparator);
        return node ? node.v : undefined;
    }
    getOrNextLower(key) {
        const node = findOrNextLower(this.root, key, this.comparator);
        return node ? node.v : undefined;
    }
    has(key) {
        return !!find(this.root, key, this.comparator);
    }
    delete(key) {
        const node = find(this.root, key, this.comparator);
        if (!node)
            return undefined;
        this.root = remove(this.root, node);
        this.size--;
        return node.v;
    }
    max() {
        return last(this.root)?.v;
    }
    iterator() {
        let curr = first(this.root);
        return () => {
            const res = curr;
            if (curr)
                curr = next(curr);
            return res ? res.v : undefined;
        };
    }
    toString(tab = '') {
        return `${this.constructor.name}${this.root ? this.toStringNode(this.root, tab + '', '') : ' ∅'}`;
    }
    toStringNode(node, tab, side) {
        let str = `\n${tab}${side === 'l' ? ' ←' : side === 'r' ? ' →' : '└─'} ${node.constructor.name} ${node.k}`;
        if (node.l)
            str += this.toStringNode(node.l, tab + '  ', 'l');
        if (node.r)
            str += this.toStringNode(node.r, tab + '  ', 'r');
        return str;
    }
}
