import { TrieNode } from '../trie/TrieNode';
import { insert, find, remove } from './radix';
export class RadixTree extends TrieNode {
    size = 0;
    constructor() {
        super('', undefined);
    }
    set(key, value) {
        this.size += insert(this, key, value);
    }
    get(key) {
        const node = find(this, key);
        return node && node.v;
    }
    delete(key) {
        const removed = remove(this, key);
        if (removed)
            this.size--;
        return removed;
    }
}
