import { insert, insertLeft, insertRight, print } from './util';
import { printTree } from '../../print/printTree';
import { findOrNextLower, first, next } from '../util';
export class RbNode {
    k;
    v;
    p = undefined;
    l = undefined;
    r = undefined;
    b = false;
    constructor(k, v) {
        this.k = k;
        this.v = v;
    }
}
const defaultComparator = (a, b) => (a === b ? 0 : a < b ? -1 : 1);
export class RbMap {
    root = undefined;
    comparator;
    constructor(comparator) {
        this.comparator = comparator || defaultComparator;
    }
    insert(k, v) {
        const item = new RbNode(k, v);
        this.root = insert(this.root, item, this.comparator);
        return item;
    }
    set(k, v) {
        const root = this.root;
        if (!root)
            return this.insert(k, v);
        const comparator = this.comparator;
        let next = root, curr = next;
        let cmp = 0;
        do {
            curr = next;
            cmp = comparator(k, curr.k);
            if (cmp === 0)
                return (curr.v = v), curr;
        } while ((next = cmp < 0 ? curr.l : curr.r));
        const node = new RbNode(k, v);
        this.root =
            cmp < 0 ? insertLeft(root, node, curr) : insertRight(root, node, curr);
        return node;
    }
    find(k) {
        const comparator = this.comparator;
        let curr = this.root;
        while (curr) {
            const cmp = comparator(k, curr.k);
            if (cmp === 0)
                return curr;
            curr = cmp < 0 ? curr.l : curr.r;
        }
        return undefined;
    }
    get(k) {
        return this.find(k)?.v;
    }
    has(k) {
        return !!this.find(k);
    }
    getOrNextLower(k) {
        return findOrNextLower(this.root, k, this.comparator) || undefined;
    }
    forEach(fn) {
        const root = this.root;
        if (!root)
            return;
        let curr = first(root);
        do
            fn(curr);
        while ((curr = next(curr)));
    }
    toString(tab) {
        return this.constructor.name + printTree(tab, [(tab) => print(this.root, tab)]);
    }
}
