import { print, toRecord } from '../radix/radix';
import { first, next } from '../util';
export class TrieNode {
    k;
    v;
    p = undefined;
    l = undefined;
    r = undefined;
    children = undefined;
    constructor(k, v) {
        this.k = k;
        this.v = v;
    }
    forChildren(callback) {
        let child = first(this.children);
        let i = 0;
        while (child) {
            callback(child, 0);
            i++;
            child = next(child);
        }
    }
    toRecord(prefix, record) {
        return toRecord(this, prefix, record);
    }
    toString(tab = '') {
        return print(this, tab);
    }
}
