export const first = (root) => {
    let curr = root;
    while (curr)
        if (curr.l)
            curr = curr.l;
        else
            return curr;
    return curr;
};
export const last = (root) => {
    let curr = root;
    while (curr)
        if (curr.r)
            curr = curr.r;
        else
            return curr;
    return curr;
};
export const next = (curr) => {
    if (curr.r) {
        curr = curr.r;
        while (curr.l)
            curr = curr.l;
        return curr;
    }
    let p = curr.p;
    while (p && p.r === curr) {
        curr = p;
        p = p.p;
    }
    return p;
};
export const prev = (curr) => {
    if (curr.l) {
        curr = curr.l;
        while (curr.r)
            curr = curr.r;
        return curr;
    }
    let p = curr.p;
    while (p && p.l === curr) {
        curr = p;
        p = p.p;
    }
    return p;
};
export const size = (root) => {
    if (!root)
        return 0;
    const start = first(root);
    let curr = start;
    let result = 1;
    while ((curr = next(curr)))
        result++;
    return result;
};
export const find = (root, key, comparator) => {
    let curr = root;
    while (curr) {
        const cmp = comparator(key, curr.k);
        if (cmp === 0)
            return curr;
        curr = cmp < 0 ? curr.l : curr.r;
    }
    return curr;
};
export const findOrNextLower = (root, key, comparator) => {
    let curr = root;
    let result = undefined;
    while (curr) {
        const cmp = comparator(curr.k, key);
        if (cmp === 0)
            return curr;
        if (cmp > 0)
            curr = curr.l;
        else {
            const next = curr.r;
            result = curr;
            if (!next)
                return result;
            curr = next;
        }
    }
    return result;
};
export const insertRight = (node, p) => {
    const r = (node.r = p.r);
    p.r = node;
    node.p = p;
    if (r)
        r.p = node;
};
export const insertLeft = (node, p) => {
    const l = (node.l = p.l);
    p.l = node;
    node.p = p;
    if (l)
        l.p = node;
};
export const insert = (root, node, comparator) => {
    if (!root)
        return node;
    const key = node.k;
    let curr = root;
    while (curr) {
        const cmp = comparator(key, curr.k);
        const next = cmp < 0 ? curr.l : curr.r;
        if (!next) {
            if (cmp < 0)
                insertLeft(node, curr);
            else
                insertRight(node, curr);
            break;
        }
        else
            curr = next;
    }
    return root;
};
export const remove = (root, node) => {
    const p = node.p;
    const l = node.l;
    const r = node.r;
    node.p = node.l = node.r = undefined;
    if (!l && !r) {
        if (!p)
            return undefined;
        else if (p.l === node)
            p.l = undefined;
        else
            p.r = undefined;
        return root;
    }
    else if (l && r) {
        let mostRightChildFromLeft = l;
        while (mostRightChildFromLeft.r)
            mostRightChildFromLeft = mostRightChildFromLeft.r;
        mostRightChildFromLeft.r = r;
        r.p = mostRightChildFromLeft;
        if (!p) {
            l.p = undefined;
            return l;
        }
        if (p.l === node)
            p.l = l;
        else
            p.r = l;
        l.p = p;
        return root;
    }
    const child = (l || r);
    child.p = p;
    if (!p)
        return child;
    else if (p.l === node)
        p.l = child;
    else
        p.r = child;
    return root;
};
