"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const json_patch_1 = require("../json-patch");
const applyPatch_1 = require("../json-patch/applyPatch");
const util_1 = require("../json-patch/util");
try {
    const buf = (0, fs_1.readFileSync)(0);
    const doc = JSON.parse(buf.toString());
    const patch = JSON.parse(process.argv[2]);
    patch.forEach(json_patch_1.validateOperation);
    const res = (0, applyPatch_1.applyPatch)(doc, patch, { mutate: true, createMatcher: util_1.createMatcherDefault });
    process.stdout.write(JSON.stringify(res.doc, null, 4) + '\n');
}
catch (error) {
    const output = error instanceof Error ? error.message : String(error);
    process.stderr.write(output + '\n');
    process.exit(1);
}
