import { IClock, ITimestampStruct, ITimespanStruct, Timestamp } from './clock';
import { Patch } from './Patch';
export declare class PatchBuilder {
    readonly clock: IClock;
    patch: Patch;
    constructor(clock: IClock);
    nextTime(): number;
    flush(): Patch;
    obj(): ITimestampStruct;
    arr(): ITimestampStruct;
    vec(): ITimestampStruct;
    str(): ITimestampStruct;
    bin(): ITimestampStruct;
    const(value: unknown): ITimestampStruct;
    val(): ITimestampStruct;
    root(val: ITimestampStruct): ITimestampStruct;
    insObj(obj: ITimestampStruct, data: [key: string, value: ITimestampStruct][]): ITimestampStruct;
    insVec(obj: ITimestampStruct, data: [index: number, value: ITimestampStruct][]): ITimestampStruct;
    setVal(obj: ITimestampStruct, val: ITimestampStruct): ITimestampStruct;
    insStr(obj: ITimestampStruct, ref: ITimestampStruct, data: string): ITimestampStruct;
    insBin(obj: ITimestampStruct, ref: ITimestampStruct, data: Uint8Array): ITimestampStruct;
    insArr(arr: ITimestampStruct, ref: ITimestampStruct, data: ITimestampStruct[]): ITimestampStruct;
    del(obj: ITimestampStruct, what: ITimespanStruct[]): ITimestampStruct;
    nop(span: number): ITimestampStruct;
    jsonObj(obj: object): ITimestampStruct;
    jsonArr(arr: unknown[]): ITimestampStruct;
    jsonStr(str: string): ITimestampStruct;
    jsonBin(bin: Uint8Array): ITimestampStruct;
    jsonVal(value: unknown): ITimestampStruct;
    jsonVec(vector: unknown[]): ITimestampStruct;
    json(json: unknown): ITimestampStruct;
    constOrJson(value: unknown): ITimestampStruct;
    maybeConst(value: unknown | Timestamp): Timestamp;
    pad(): void;
}
