"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const __1 = require("..");
const clock_1 = require("../clock");
const verbose = tslib_1.__importStar(require("../codec/verbose"));
const compact = tslib_1.__importStar(require("../codec/compact"));
const binary = tslib_1.__importStar(require("../codec/binary"));
const cbor = tslib_1.__importStar(require("../../json-pack/cbor/shared"));
const clock = new clock_1.LogicalClock(123, 456);
const builder = new __1.PatchBuilder(clock);
const stringId = builder.str();
builder.insStr(stringId, stringId, 'bar');
const objectId = builder.obj();
builder.insObj(objectId, [['foo', stringId]]);
builder.root(objectId);
console.log(builder.patch + '');
console.log(JSON.stringify(verbose.encode(builder.patch), null, 2));
console.log('Size:', JSON.stringify(verbose.encode(builder.patch)).length);
console.log(JSON.stringify(compact.encode(builder.patch), null, 2));
console.log('Size:', JSON.stringify(compact.encode(builder.patch)).length);
console.log('Size:', cbor.encode(compact.encode(builder.patch)).length);
console.log(binary.encode(builder.patch));
console.log(Buffer.from(binary.encode(builder.patch)));
console.log('Size:', binary.encode(builder.patch).length);
